//
//  CRSceneItemPort.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 6/16/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// Base scene item port
//////////////////////////////////////////////////////////////////////
typedef enum {
	CRPortInput			= 0x01,
	CRPortOutput		= 0x02,
	CRPortInputOutput	= CRPortInput | CRPortOutput,
	CRPortPrivate		= 0x10,
	CRPortPublic		= 0x20,
} CRSceneItemPortType;

@interface CRSceneItemPort : NSObject
{
	BOOL						fetching;
	
@protected
	NSString*					name;
	NSUInteger					type;						// port type (input, output)
	NSUInteger					usage;						// port usage (undo, coding, copying)
	NSString*					codingTransformer;			// special transformer for NSCoding, suitable for struct types
	NSUInteger					restrictions;				// usage restrictions, can disallow specific usage part for a while
	
	// links
	CRSceneItemPort* assigned	sourcePort;					// source port
	CRMultiDelegate*			onDirty;					// signals port is dirty
	CRMultiDelegate*			onRestrictionsWillChange;	// signals port restrictions will be changed
	CRMultiDelegate*			onRestrictionsDidChange;	// signals port restrictions did change
	CRMultiDelegate*			onDelete;					// signals port is being dellocated
	BOOL						isDirty;					// 'dirty' flag
}

// main parameters
@property (nonatomic, readonly) NSString*			name;
@property (nonatomic, readonly) NSUInteger			type;
@property (nonatomic, readonly) NSUInteger			usage;
@property (nonatomic, readonly) NSString*			codingTransformer;
@property (nonatomic, readonly) NSUInteger			cleanUsage;		// usage with restrictions
@property (nonatomic, assign)	NSUInteger			restrictions;

// events
@property (readonly,  assign)	CRSceneItemPort*	sourcePort;
@property (nonatomic, readonly) CRMultiDelegate*	onDirty;
@property (nonatomic, readonly)	CRMultiDelegate*	onRestrictionsWillChange;
@property (nonatomic, readonly)	CRMultiDelegate*	onRestrictionsDidChange;
@property (nonatomic, readonly) CRMultiDelegate*	onDelete;
@property (nonatomic, assign)	BOOL				isDirty;

// auxiliary
@property (nonatomic, readonly) BOOL				isInput;
@property (nonatomic, readonly) BOOL				isOutput;
@property (nonatomic, readonly) BOOL				isPrivate;
@property (nonatomic, readonly) BOOL				isPublic;

// initializer
- (id)initWithName:(NSString *)portName type:(NSUInteger)portType usage:(NSUInteger)usage codingTransformer:(NSString *)transformerName;

// links
- (void)linkTo:(CRSceneItemPort *)sourcePort;

// useful
- (BOOL)hasUsageFlag:(NSUInteger)flag;

// value get/set
- (id)value;
- (void)setValue:(id)value;
- (void)setValueSilently:(id)value;

- (void)fetchValue;

@end